<?php

namespace App\Http\Controllers;
use App\Traits\UploadTrait;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\repertory;
use App\Calendar;
use App\Http\Resources\Calendar as CalendarResource;
use Illuminate\Support\Facades\DB;

class CalendarController extends Controller
{
    public function __construct(){
        return $this->middleware('auth');
    }

    use UploadTrait;

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $cal = Calendar::all();
        
        return view('calendars.index', compact('cal'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //

        $calendar = new Calendar();

        $calendar->date = $request->input('date');
        $calendar->repertory_id = $idd = $request->input('repertory_id');

        

        $calendar->save();
        return redirect('list/'.$idd)->with(['status' => 'Client ajoutée avec succée.']);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Calendar  $calendar
     * @return \Illuminate\Http\Response
     */
    public function show(Calendar $calendar)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Calendar  $calendar
     * @return \Illuminate\Http\Response
     */
    public function edit(Calendar $calendar, $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Calendar  $calendar
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Calendar $calendar, $id)
    {
        //
        $idd = $request->input('repertory_id');

        $cale = Calendar::find($id);

        $cale->date = $request->input('date');
        $cale->titre = $request->input('titre');
        $cale->content = $request->input('content');
        $cale->contentIMA = $request->input('contentIMA');

        if ($request->file('image')) {
            // user found
            $image = $request->file('image');
            // Make a image name based on user name and current timestamp
            $name = str_slug($request->input('repertory_id')).'_'.time();
            // Define folder path
            $folder = '/uploads/publications/';
            // Make a file path where image will be stored [ folder path + file name + file extension]
            $filePath = $folder . $name. '.' . $image->getClientOriginalExtension();
            // Upload image
            $this->uploadOne($image, $folder, 'public', $name);
            // Set user profile image path in database to filePath
            $cale->picture = $filePath;
         }

        

        $cale->save();
        return redirect('list/'.$idd)->with(['status' => 'Client ajoutée avec succée.']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Calendar  $calendar
     * @return \Illuminate\Http\Response
     */
    public function destroy(Calendar $calendar)
    {
        //
    }
    public function dik()
    {
        //
        $calendars = Calendar::all();
        return CalendarResource::collection($calendars);
    }

    public function calend($id)
    {
        //
        //$fin = DB::table('repertories')->where('client_id', $id)->first();
        $fin = repertory::all()->where('id', $id);
        $cal = Calendar::all()->where('repertory_id', $id);

        return view('calendars.index', [
            'cals' => $cal,
            'idd' => $id,
            'fins'=> $fin
            
            ]);
            
    }

}
